from math import exp
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.patches import Circle
# Initialize 6 points randomly within a unit circle centered at the origin
points = np.random.rand(20, 2) * 2 - 1
for i in range(len(points)):
    if np.sum(points[i]**2) > 1:
        points[i] /= np.sqrt(np.sum(points[i]**2))

# Objective function to minimize potential energy (maximize entropy)
def objective_function(points):
    num_points = points.shape[0]
    potential_energy = 0
    for i in range(num_points):
        for j in range(i + 1, num_points):
            distance = np.linalg.norm(points[i] - points[j])
            if distance > 0:
                potential_energy += 1 / distance**2
    return potential_energy

# Gradient of the potential energy function with respect to the points
import numpy as np

def gradient(points):
    diff = points[:, np.newaxis, :] - points[np.newaxis, :, :]
    distances = np.linalg.norm(diff, axis=2)
    np.fill_diagonal(distances, 0.0000001)  
    
    exp_term = np.exp(-(distances**2) * 8) 
    exp_term = exp_term/np.sum(exp_term) #delete this code for exp left

    grad_contribution = (exp_term* distances)[:, :, np.newaxis] * (diff / distances[:, :, np.newaxis]) *(1-exp_term)[:, :, np.newaxis] # delete this code *(1-exp_term)[:, :, np.newaxis] for exp left
    
    np.fill_diagonal(grad_contribution[:, :, 0], 0)
    np.fill_diagonal(grad_contribution[:, :, 1], 0)
    gradient = -np.sum(grad_contribution, axis=1)
    
    self_vectors = points
    self_distances = np.linalg.norm(self_vectors, axis=1, keepdims=True)
    expdis = np.exp(-(self_distances**2) * 8)
    expdis = expdis/np.sum(expdis) #delete this code for exp left

    self_contributions = (self_vectors / self_distances) * expdis * self_distances*20 *(1-expdis)  # delete this code *(1-expdis) for exp left
    gradient -= self_contributions.squeeze()
    
    return gradient

def gradient2(points):
    diff = points[:, np.newaxis, :] - points[np.newaxis, :, :]
    distances = np.linalg.norm(diff, axis=2)
    np.fill_diagonal(distances, 0.0000001)  
    
    exp_term = np.exp(-(distances**2) * 8) 

    grad_contribution = (exp_term* distances)[:, :, np.newaxis] * (diff / distances[:, :, np.newaxis]) 
    
    np.fill_diagonal(grad_contribution[:, :, 0], 0)
    np.fill_diagonal(grad_contribution[:, :, 1], 0)
    gradient = -np.sum(grad_contribution, axis=1)
    
    self_vectors = points
    self_distances = np.linalg.norm(self_vectors, axis=1, keepdims=True)
    expdis = np.exp(-(self_distances**2) * 8)

    self_contributions = (self_vectors / self_distances) * expdis * self_distances*20 
    gradient -= self_contributions.squeeze()
    
    return gradient

def _gradient(points):
    num_points = points.shape[0]
    grad = np.zeros_like(points)
    for i in range(num_points):
        for j in range(num_points):
            if i != j:
                vector = points[i] - points[j]
                distance = np.linalg.norm(vector)
                if distance > 0:
                    # Gradient contribution from the repulsive force
                    grad[i] -= (vector / distance) * np.exp(-(distance**2)*10) * distance * (1 - np.exp(-(distance**2)*10)) 
                vector = points[i]
                distance = np.linalg.norm(vector)
                if distance > 0:
                    # Gradient contribution from the repulsive force
                    grad[i] -= (vector / distance) * np.exp(-(distance**2)*10) * distance * (1 - np.exp(-(distance**2)*10)) 
    return grad

# Gradient descent parameters
learning_rate = 0.2
iterations = 10000

# Gradient descent to minimize the potential energy
for _ in range(iterations):
    grad = gradient(points) 
    #grad = gradient2(points)
    points -= learning_rate * grad
    # Keep points within the unit circle
    for i in range(len(points)):
        if np.sum(points[i]**2) > 1:
            points[i] /= np.sqrt(np.sum(points[i]**2))

    diff = points[:, np.newaxis, :] - points[np.newaxis, :, :]
    distances = np.linalg.norm(diff, axis=2)
    np.fill_diagonal(distances, 0.0000001) 
    
    exp_term = np.exp(-(distances**2) * 8) 

    self_vectors = points
    self_distances = np.linalg.norm(self_vectors, axis=1, keepdims=True)
    
    expdis = np.exp(-(self_distances**2) * 8)
tsum = 0

for i in range(20):
    exp_term[i] = exp_term[i] + expdis[i]



for j in range(20): 
    p = 0
    msum = 0
    for i in range(20):
        if i == j:
            continue
        if p == 0:
            msum = np.sqrt(np.sum((exp_term[j] - exp_term[i])**2))
            p = 1
        if msum > np.sqrt(np.sum((exp_term[j] - exp_term[i])**2)):
            msum = np.sqrt(np.sum((exp_term[j] - exp_term[i])**2))
        #print("i",msum)
    #print("iiii",msum)
    tsum = tsum + msum

#print(tsum/20)
print(distances)
dist = np.sort(distances, axis=1)[:, 1]
print("aaa = ",sum(dist**2)+sum(sum(points**2))*2)

print("sum",np.sum(np.min(distances, axis=-1)))
#print(len(diff)/(np.sum(exp_term)+np.sum(expdis)))

# Plot the final configuration of points
plt.figure(figsize=(6, 6))
plt.scatter(points[:, 0], points[:, 1], c='blue')
plt.xlim(-1, 1)
plt.ylim(-1, 1)
#plt.title('Result of Maximizeing difference of distribution directly')
circle = Circle((0, 0), 1, edgecolor='lightgreen', facecolor='none', linewidth=2)
plt.gca().add_patch(circle)

# Remove grid
plt.grid(False)
plt.show()
